/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.thema;

import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.ThesaurusDatabase;
import data.structures.classification.NuagePondere;
import data.structures.classification.LemmePondere;
import data.structures.tagging.LemmaItem;
import data.structures.tagging.GraphLemmaItem;

import java.util.Vector;

public class ThemaGraph {
    public final static int BASE_UNIQUEMENT = 0;
    public final static int BASE_ENRICHIE = 1;
    public final static int TOUT = 2;
    public final static int ENRICH_UNIQUEMENT = 3;


    private GraphLemmaItem[] gitems0;
    private GraphLemmaItem[] gitems1;
    private GraphLemmaItem[] gitems2;
    private GraphLemmaItem[] gitems3;

    public ThemaGraph(Database db){
        ThesaurusDatabase tDB = new ThesaurusDatabase(db);
        Vector<ThemaItem> items0 = new Vector<ThemaItem>();
        Vector<ThemaItem> items1 = new Vector<ThemaItem>();
        Vector<ThemaItem> items2 = new Vector<ThemaItem>();
        Vector<ThemaItem> items3 = new Vector<ThemaItem>();
        try {
            items0 = new Vector<ThemaItem>(tDB.getTopClasses());
            items1 = (Vector<ThemaItem>)(items0.clone());
            items2 = new Vector<ThemaItem>(tDB.getAllClasses());
            items3 = (Vector<ThemaItem>)(items0.clone());
            gitems0 = new GraphLemmaItem[items0.size()];
            for(int i=0; i<gitems0.length; i++){
                gitems0[i] = new GraphLemmaItem();
                gitems0[i].setNodeID(items0.elementAt(i).getConceptID());
                gitems0[i].setNodeName(items0.elementAt(i).getConceptName());
                gitems0[i].setLemmas(tDB.getLemmas(items0.elementAt(i).getConceptID()));
            }
            gitems1 = new GraphLemmaItem[items1.size()];
            for(int i=0; i<gitems1.length; i++){
                gitems1[i] = new GraphLemmaItem();
                gitems1[i].setNodeID(items1.elementAt(i).getConceptID());
                gitems1[i].setNodeName(items1.elementAt(i).getConceptName());
                gitems1[i].setLemmas(tDB.getExtendedLemmas(items1.elementAt(i).getConceptID()));
            }
            gitems2 = new GraphLemmaItem[items2.size()];
            for(int i=0; i<gitems2.length; i++){
                gitems2[i] = new GraphLemmaItem();
                gitems2[i].setNodeID(items2.elementAt(i).getConceptID());
                gitems2[i].setNodeName(items2.elementAt(i).getConceptName());
                gitems2[i].setLemmas(tDB.getLemmas(items2.elementAt(i).getConceptID()));
            }
            gitems3 = new GraphLemmaItem[items1.size()];
            for(int i=0; i<gitems3.length; i++){
                gitems3[i] = new GraphLemmaItem();
                gitems3[i].setNodeID(items3.elementAt(i).getConceptID());
                gitems3[i].setNodeName(items3.elementAt(i).getConceptName());
                gitems3[i].setLemmas(tDB.getOnlyExtendedLemmas(items3.elementAt(i).getConceptID()));
            }
        } catch(data.base.NoBaseException nbe){

        }
    }

    public GraphLemmaItem[] getItems(int couverture){
        GraphLemmaItem[] items = null;
        switch(couverture){
            case BASE_UNIQUEMENT :
                items = gitems0;
                break;
            case BASE_ENRICHIE :
                items = gitems1;
                break;
            case ENRICH_UNIQUEMENT :
                items = gitems3;
                break;
            default : // TOUT
                items = gitems2;
        }
        return items;
    }
}
